var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField = (obj, key, value) => {
  __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var __accessCheck = (obj, member, msg) => {
  if (!member.has(obj))
    throw TypeError("Cannot " + msg);
};
var __privateGet = (obj, member, getter) => {
  __accessCheck(obj, member, "read from private field");
  return getter ? getter.call(obj) : member.get(obj);
};
var __privateAdd = (obj, member, value) => {
  if (member.has(obj))
    throw TypeError("Cannot add the same private member more than once");
  member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
};
var __privateSet = (obj, member, value, setter) => {
  __accessCheck(obj, member, "write to private field");
  setter ? setter.call(obj, value) : member.set(obj, value);
  return value;
};
var __privateMethod = (obj, member, method) => {
  __accessCheck(obj, member, "access private method");
  return method;
};
var _loadRequested, _hasLoaded, _isInit, _isWaiting, _closeToEnded, _paused, _currentTime, _duration, _seeking, _config, _upgradeProperty, upgradeProperty_fn;
import { J as React } from "./index-D3SQBzf9.js";
const EMBED_BASE = "https://open.spotify.com";
const MATCH_SRC = /open\.spotify\.com\/(\w+)\/(\w+)/i;
const API_URL = "https://open.spotify.com/embed-podcast/iframe-api/v1";
const API_GLOBAL = "SpotifyIframeApi";
const API_GLOBAL_READY = "onSpotifyIframeApiReady";
function getTemplateHTML(attrs, props = {}) {
  const iframeAttrs = {
    src: serializeIframeUrl(attrs, props),
    scrolling: "no",
    frameborder: 0,
    width: "100%",
    height: "100%",
    allow: "accelerometer; fullscreen; autoplay; encrypted-media; gyroscope; picture-in-picture"
  };
  return (
    /*html*/
    `
    <style>
      :host {
        display: inline-block;
        min-width: 160px;
        min-height: 80px;
        position: relative;
      }
      iframe {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        overflow: hidden;
      }
      :host(:not([controls])) {
        display: none !important;
      }
    </style>
    <iframe${serializeAttributes(iframeAttrs)}></iframe>
  `
  );
}
function serializeIframeUrl(attrs, props) {
  var _a, _b, _c;
  if (!attrs.src)
    return;
  const matches = attrs.src.match(MATCH_SRC);
  const type = matches && matches[1];
  const metaId = matches && matches[2];
  const params = {
    t: (_a = props.config) == null ? void 0 : _a.startAt,
    theme: ((_b = props.config) == null ? void 0 : _b.theme) === "dark" ? "0" : null
  };
  const videoPath = ((_c = props.config) == null ? void 0 : _c.preferVideo) ? "/video" : "";
  return `${EMBED_BASE}/embed/${type}/${metaId}${videoPath}?${serialize(params)}`;
}
class SpotifyAudioElement extends (globalThis.HTMLElement ?? class {
}) {
  constructor() {
    super();
    // This is a pattern to update property values that are set before
    // the custom element is upgraded.
    // https://web.dev/custom-elements-best-practices/#make-properties-lazy
    __privateAdd(this, _upgradeProperty);
    __publicField(this, "loadComplete", new PublicPromise());
    __privateAdd(this, _loadRequested, void 0);
    __privateAdd(this, _hasLoaded, void 0);
    __privateAdd(this, _isInit, void 0);
    __privateAdd(this, _isWaiting, false);
    __privateAdd(this, _closeToEnded, false);
    __privateAdd(this, _paused, true);
    __privateAdd(this, _currentTime, 0);
    __privateAdd(this, _duration, NaN);
    __privateAdd(this, _seeking, false);
    __privateAdd(this, _config, null);
    __privateMethod(this, _upgradeProperty, upgradeProperty_fn).call(this, "config");
  }
  async load() {
    var _a, _b, _c;
    if (__privateGet(this, _loadRequested))
      return;
    if (__privateGet(this, _hasLoaded))
      this.loadComplete = new PublicPromise();
    __privateSet(this, _hasLoaded, true);
    await __privateSet(this, _loadRequested, Promise.resolve());
    __privateSet(this, _loadRequested, null);
    __privateSet(this, _isWaiting, false);
    __privateSet(this, _closeToEnded, false);
    __privateSet(this, _currentTime, 0);
    __privateSet(this, _duration, NaN);
    __privateSet(this, _seeking, false);
    this.dispatchEvent(new Event("emptied"));
    let oldApi = this.api;
    this.api = null;
    if (!this.src) {
      return;
    }
    this.dispatchEvent(new Event("loadstart"));
    const options = {
      t: (_a = this.config) == null ? void 0 : _a.startAt,
      theme: ((_b = this.config) == null ? void 0 : _b.theme) === "dark" ? "0" : null,
      preferVideo: (_c = this.config) == null ? void 0 : _c.preferVideo
    };
    if (__privateGet(this, _isInit)) {
      this.api = oldApi;
      this.api.iframeElement.src = serializeIframeUrl(namedNodeMapToObject(this.attributes), this);
    } else {
      __privateSet(this, _isInit, true);
      if (!this.shadowRoot) {
        this.attachShadow({ mode: "open" });
        this.shadowRoot.innerHTML = getTemplateHTML(namedNodeMapToObject(this.attributes), this);
      }
      let iframe = this.shadowRoot.querySelector("iframe");
      const Spotify = await loadScript(API_URL, API_GLOBAL, API_GLOBAL_READY);
      this.api = await new Promise((resolve) => Spotify.createController(iframe, options, resolve));
      this.api.iframeElement = iframe;
      this.api.addListener("ready", () => {
        this.dispatchEvent(new Event("loadedmetadata"));
        this.dispatchEvent(new Event("durationchange"));
        this.dispatchEvent(new Event("volumechange"));
      });
      this.api.addListener("playback_update", (event) => {
        if (__privateGet(this, _closeToEnded) && __privateGet(this, _paused) && (event.data.isBuffering || !event.data.isPaused)) {
          __privateSet(this, _closeToEnded, false);
          this.currentTime = 1;
          return;
        }
        if (event.data.duration / 1e3 !== __privateGet(this, _duration)) {
          __privateSet(this, _closeToEnded, false);
          __privateSet(this, _duration, event.data.duration / 1e3);
          this.dispatchEvent(new Event("durationchange"));
        }
        if (event.data.position / 1e3 !== __privateGet(this, _currentTime)) {
          __privateSet(this, _seeking, false);
          __privateSet(this, _closeToEnded, false);
          __privateSet(this, _currentTime, event.data.position / 1e3);
          this.dispatchEvent(new Event("timeupdate"));
        }
        if (!__privateGet(this, _isWaiting) && !__privateGet(this, _paused) && event.data.isPaused) {
          __privateSet(this, _paused, true);
          this.dispatchEvent(new Event("pause"));
          return;
        }
        if (__privateGet(this, _paused) && (event.data.isBuffering || !event.data.isPaused)) {
          __privateSet(this, _paused, false);
          this.dispatchEvent(new Event("play"));
          __privateSet(this, _isWaiting, event.data.isBuffering);
          if (__privateGet(this, _isWaiting)) {
            this.dispatchEvent(new Event("waiting"));
          } else {
            this.dispatchEvent(new Event("playing"));
          }
          return;
        }
        if (__privateGet(this, _isWaiting) && !event.data.isPaused) {
          __privateSet(this, _isWaiting, false);
          this.dispatchEvent(new Event("playing"));
          return;
        }
        if (!this.paused && !this.seeking && !__privateGet(this, _closeToEnded) && Math.ceil(this.currentTime) >= this.duration) {
          __privateSet(this, _closeToEnded, true);
          if (this.loop) {
            this.currentTime = 1;
            return;
          }
          if (!this.continuous) {
            this.pause();
            this.dispatchEvent(new Event("ended"));
          }
          return;
        }
      });
    }
    this.loadComplete.resolve();
    await this.loadComplete;
  }
  async attributeChangedCallback(attrName, oldValue, newValue) {
    if (oldValue === newValue)
      return;
    switch (attrName) {
      case "src": {
        this.load();
        return;
      }
    }
  }
  async play() {
    var _a;
    __privateSet(this, _paused, false);
    __privateSet(this, _isWaiting, true);
    this.dispatchEvent(new Event("play"));
    await this.loadComplete;
    return (_a = this.api) == null ? void 0 : _a.resume();
  }
  async pause() {
    var _a;
    await this.loadComplete;
    return (_a = this.api) == null ? void 0 : _a.pause();
  }
  get config() {
    return __privateGet(this, _config);
  }
  set config(value) {
    __privateSet(this, _config, value);
  }
  get paused() {
    return __privateGet(this, _paused) ?? true;
  }
  get muted() {
    return false;
  }
  set muted(val) {
  }
  get volume() {
    return 1;
  }
  set volume(val) {
  }
  get ended() {
    return Math.ceil(this.currentTime) >= this.duration;
  }
  get seeking() {
    return __privateGet(this, _seeking);
  }
  get loop() {
    return this.hasAttribute("loop");
  }
  set loop(val) {
    if (this.loop == val)
      return;
    this.toggleAttribute("loop", Boolean(val));
  }
  get currentTime() {
    return __privateGet(this, _currentTime);
  }
  set currentTime(val) {
    if (this.currentTime == val)
      return;
    __privateSet(this, _seeking, true);
    let oldTime = __privateGet(this, _currentTime);
    __privateSet(this, _currentTime, val);
    this.dispatchEvent(new Event("timeupdate"));
    __privateSet(this, _currentTime, oldTime);
    this.loadComplete.then(() => {
      var _a;
      (_a = this.api) == null ? void 0 : _a.seek(val);
    });
  }
  get duration() {
    return __privateGet(this, _duration);
  }
  get src() {
    return this.getAttribute("src");
  }
  set src(val) {
    this.setAttribute("src", `${val}`);
  }
}
_loadRequested = new WeakMap();
_hasLoaded = new WeakMap();
_isInit = new WeakMap();
_isWaiting = new WeakMap();
_closeToEnded = new WeakMap();
_paused = new WeakMap();
_currentTime = new WeakMap();
_duration = new WeakMap();
_seeking = new WeakMap();
_config = new WeakMap();
_upgradeProperty = new WeakSet();
upgradeProperty_fn = function(prop) {
  if (Object.prototype.hasOwnProperty.call(this, prop)) {
    const value = this[prop];
    delete this[prop];
    this[prop] = value;
  }
};
__publicField(SpotifyAudioElement, "getTemplateHTML", getTemplateHTML);
__publicField(SpotifyAudioElement, "shadowRootOptions", { mode: "open" });
__publicField(SpotifyAudioElement, "observedAttributes", [
  "controls",
  "loop",
  "src"
]);
function serializeAttributes(attrs) {
  let html = "";
  for (const key in attrs) {
    const value = attrs[key];
    if (value === "")
      html += ` ${key}`;
    else
      html += ` ${key}="${value}"`;
  }
  return html;
}
function serialize(props) {
  return String(new URLSearchParams(boolToBinary(props)));
}
function boolToBinary(props) {
  let p = {};
  for (let key in props) {
    let val = props[key];
    if (val === true || val === "")
      p[key] = 1;
    else if (val === false)
      p[key] = 0;
    else if (val != null)
      p[key] = val;
  }
  return p;
}
function namedNodeMapToObject(namedNodeMap) {
  let obj = {};
  for (let attr of namedNodeMap) {
    obj[attr.name] = attr.value;
  }
  return obj;
}
const loadScriptCache = {};
async function loadScript(src, globalName, readyFnName) {
  if (loadScriptCache[src])
    return loadScriptCache[src];
  if (self[globalName]) {
    return Promise.resolve(self[globalName]);
  }
  return loadScriptCache[src] = new Promise(function(resolve, reject) {
    const script = document.createElement("script");
    script.src = src;
    const ready = (api) => resolve(api);
    self[readyFnName] = ready;
    script.onload = () => !readyFnName;
    script.onerror = reject;
    document.head.append(script);
  });
}
class PublicPromise extends Promise {
  constructor(executor = () => {
  }) {
    let res, rej;
    super((resolve, reject) => {
      executor(resolve, reject);
      res = resolve;
      rej = reject;
    });
    this.resolve = res;
    this.reject = rej;
  }
}
if (globalThis.customElements && !globalThis.customElements.get("spotify-audio")) {
  globalThis.customElements.define("spotify-audio", SpotifyAudioElement);
}
var spotify_audio_element_default = SpotifyAudioElement;
var reservedReactProps = /* @__PURE__ */ new Set([
  "style",
  "children",
  "ref",
  "key",
  "suppressContentEditableWarning",
  "suppressHydrationWarning",
  "dangerouslySetInnerHTML"
]);
var reactPropToAttrNameMap = {
  className: "class",
  htmlFor: "for"
};
function defaultToAttributeName(propName) {
  return propName.toLowerCase();
}
function defaultToAttributeValue(propValue) {
  if (typeof propValue === "boolean")
    return propValue ? "" : void 0;
  if (typeof propValue === "function")
    return void 0;
  if (typeof propValue === "object" && propValue !== null)
    return void 0;
  return propValue;
}
function createComponent({
  react: React2,
  tagName,
  elementClass,
  events,
  displayName,
  defaultProps,
  toAttributeName = defaultToAttributeName,
  toAttributeValue = defaultToAttributeValue
}) {
  const IS_REACT_19_OR_NEWER = Number.parseInt(React2.version) >= 19;
  const ReactComponent = React2.forwardRef((props, ref) => {
    var _a, _b;
    const elementRef = React2.useRef(null);
    const prevElemPropsRef = React2.useRef(/* @__PURE__ */ new Map());
    const eventProps = {};
    const attrs = {};
    const reactProps = {};
    const elementProps = {};
    for (const [k, v] of Object.entries(props)) {
      if (reservedReactProps.has(k)) {
        reactProps[k] = v;
        continue;
      }
      const attrName = toAttributeName(reactPropToAttrNameMap[k] ?? k);
      if (k in elementClass.prototype && !(k in (((_a = globalThis.HTMLElement) == null ? void 0 : _a.prototype) ?? {})) && !((_b = elementClass.observedAttributes) == null ? void 0 : _b.some((attr) => attr === attrName))) {
        elementProps[k] = v;
        continue;
      }
      if (k.startsWith("on")) {
        eventProps[k] = v;
        continue;
      }
      const attrValue = toAttributeValue(v);
      if (attrName && attrValue != null) {
        attrs[attrName] = String(attrValue);
        if (!IS_REACT_19_OR_NEWER) {
          reactProps[attrName] = attrValue;
        }
      }
      if (attrName && IS_REACT_19_OR_NEWER) {
        const attrValueFromDefault = defaultToAttributeValue(v);
        if (attrValue !== attrValueFromDefault) {
          reactProps[attrName] = attrValue;
        } else {
          reactProps[attrName] = v;
        }
      }
    }
    if (typeof window !== "undefined") {
      for (const propName in eventProps) {
        const callback = eventProps[propName];
        const useCapture = propName.endsWith("Capture");
        const eventName = ((events == null ? void 0 : events[propName]) ?? propName.slice(2).toLowerCase()).slice(
          0,
          useCapture ? -7 : void 0
        );
        React2.useLayoutEffect(() => {
          const eventTarget = elementRef == null ? void 0 : elementRef.current;
          if (!eventTarget || typeof callback !== "function")
            return;
          eventTarget.addEventListener(eventName, callback, useCapture);
          return () => {
            eventTarget.removeEventListener(eventName, callback, useCapture);
          };
        }, [elementRef == null ? void 0 : elementRef.current, callback]);
      }
      React2.useLayoutEffect(() => {
        if (elementRef.current === null)
          return;
        const newElemProps = /* @__PURE__ */ new Map();
        for (const key in elementProps) {
          setProperty(elementRef.current, key, elementProps[key]);
          prevElemPropsRef.current.delete(key);
          newElemProps.set(key, elementProps[key]);
        }
        for (const [key, _value] of prevElemPropsRef.current) {
          setProperty(elementRef.current, key, void 0);
        }
        prevElemPropsRef.current = newElemProps;
      });
    }
    if (typeof window === "undefined" && (elementClass == null ? void 0 : elementClass.getTemplateHTML) && (elementClass == null ? void 0 : elementClass.shadowRootOptions)) {
      const { mode, delegatesFocus } = elementClass.shadowRootOptions;
      const templateShadowRoot = React2.createElement("template", {
        shadowrootmode: mode,
        shadowrootdelegatesfocus: delegatesFocus,
        dangerouslySetInnerHTML: {
          __html: elementClass.getTemplateHTML(attrs, props)
        }
      });
      reactProps.children = [templateShadowRoot, reactProps.children];
    }
    return React2.createElement(tagName, {
      ...defaultProps,
      ...reactProps,
      ref: React2.useCallback(
        (node) => {
          elementRef.current = node;
          if (typeof ref === "function") {
            ref(node);
          } else if (ref !== null) {
            ref.current = node;
          }
        },
        [ref]
      )
    });
  });
  ReactComponent.displayName = displayName ?? elementClass.name;
  return ReactComponent;
}
function setProperty(node, name, value) {
  var _a;
  node[name] = value;
  if (value == null && name in (((_a = globalThis.HTMLElement) == null ? void 0 : _a.prototype) ?? {})) {
    node.removeAttribute(name);
  }
}
var react_default = createComponent({
  react: React,
  tagName: "spotify-audio",
  elementClass: spotify_audio_element_default,
  toAttributeName(propName) {
    if (propName === "muted")
      return "";
    if (propName === "defaultMuted")
      return "muted";
    return defaultToAttributeName(propName);
  }
});
/*! Bundled license information:

ce-la-react/dist/ce-la-react.js:
  (**
   * @license
   * Copyright 2018 Google LLC
   * SPDX-License-Identifier: BSD-3-Clause
   *
   * Modified version of `@lit/react` for vanilla custom elements with support for SSR.
   *)
*/
export {
  react_default as default
};
