var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField = (obj, key, value) => {
  __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var __accessCheck = (obj, member, msg) => {
  if (!member.has(obj))
    throw TypeError("Cannot " + msg);
};
var __privateGet = (obj, member, getter) => {
  __accessCheck(obj, member, "read from private field");
  return getter ? getter.call(obj) : member.get(obj);
};
var __privateAdd = (obj, member, value) => {
  if (member.has(obj))
    throw TypeError("Cannot add the same private member more than once");
  member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
};
var __privateSet = (obj, member, value, setter) => {
  __accessCheck(obj, member, "write to private field");
  setter ? setter.call(obj, value) : member.set(obj, value);
  return value;
};
var __privateMethod = (obj, member, method) => {
  __accessCheck(obj, member, "access private method");
  return method;
};
var _loadRequested, _hasLoaded, _muted, _currentTime, _paused, _config, _volume, _duration, _iframe, _onMessage, _post, post_fn, _seekTo, seekTo_fn, _mute, mute_fn, _unMute, unMute_fn, _upgradeProperty, upgradeProperty_fn;
import { J as React } from "./index-CNPKVdAr.js";
const EMBED_BASE = "https://www.tiktok.com/player/v1";
const MATCH_SRC = /tiktok\.com\/(?:@[^/]+\/video\/)?(\d+)(?:\/([\w-]+))?/;
const PlayerState = { INIT: -1, ENDED: 0, PLAYING: 1, PAUSED: 2, BUFFERING: 3 };
const EventMap = {
  [PlayerState.INIT]: "emptied",
  [PlayerState.PAUSED]: "pause",
  [PlayerState.ENDED]: "ended",
  [PlayerState.PLAYING]: "play",
  [PlayerState.BUFFERING]: "waiting"
};
function getTemplateHTML(attrs, props = {}) {
  const iframeAttrs = {
    src: serializeIframeUrl(attrs, props),
    frameborder: 0,
    width: "100%",
    height: "100%",
    allow: "accelerometer; autoplay; fullscreen; encrypted-media; gyroscope; picture-in-picture"
  };
  if (props.config) {
    iframeAttrs["data-config"] = JSON.stringify(props.config);
  }
  return (
    /*html*/
    `
    <style>
      :host {
        display:inline-block;
        min-width: 300px;
        min-height: 150px;
        position: relative;
      }
      iframe {
        position:absolute;
        top:0;
        left:0;
        width:100%;
        height:100%;
        border:0;
      }
    </style>
    <iframe ${serializeAttributes(iframeAttrs)} title="TikTok video"></iframe>
  `
  );
}
function serializeIframeUrl(attrs, props = {}) {
  if (!attrs.src)
    return;
  const matches = attrs.src.match(MATCH_SRC);
  const srcId = matches && matches[1];
  const params = {
    controls: attrs.controls === "" ? null : 0,
    autoplay: attrs.autoplay,
    muted: attrs.muted,
    loop: attrs.loop,
    rel: 0,
    ...props.config
  };
  return `${EMBED_BASE}/${srcId}?${serialize(params)}`;
}
const _TikTokVideoElement = class _TikTokVideoElement extends (globalThis.HTMLElement ?? class {
}) {
  constructor() {
    super();
    __privateAdd(this, _post);
    __privateAdd(this, _seekTo);
    __privateAdd(this, _mute);
    __privateAdd(this, _unMute);
    // This is a pattern to update property values that are set before
    // the custom element is upgraded.
    // https://web.dev/custom-elements-best-practices/#make-properties-lazy
    __privateAdd(this, _upgradeProperty);
    __publicField(this, "loadComplete", new PublicPromise());
    __privateAdd(this, _loadRequested, void 0);
    __privateAdd(this, _hasLoaded, void 0);
    __privateAdd(this, _muted, false);
    __privateAdd(this, _currentTime, 0);
    __privateAdd(this, _paused, true);
    __privateAdd(this, _config, null);
    __privateAdd(this, _volume, 100);
    __privateAdd(this, _duration, 0);
    __privateAdd(this, _iframe, void 0);
    __privateAdd(this, _onMessage, (event) => {
      const msg = event.data;
      if (!(msg == null ? void 0 : msg["x-tiktok-player"]))
        return;
      switch (msg.type) {
        case "onPlayerReady":
          this.loadComplete.resolve();
          break;
        case "onStateChange": {
          __privateSet(this, _paused, [PlayerState.INIT, PlayerState.PAUSED, PlayerState.ENDED].includes(msg.value));
          const eventType = EventMap[msg.value];
          if (eventType)
            this.dispatchEvent(new Event(eventType));
          break;
        }
        case "onCurrentTime":
          __privateSet(this, _currentTime, msg.value.currentTime);
          __privateSet(this, _duration, msg.value.duration);
          this.dispatchEvent(new Event("durationchange"));
          this.dispatchEvent(new Event("timeupdate"));
          break;
        case "onVolumeChange":
          __privateSet(this, _volume, msg.value);
          this.dispatchEvent(new Event("volumechange"));
          break;
        case "onMute":
          __privateSet(this, _muted, msg.value ? true : false);
          __privateSet(this, _volume, msg.value ? 0 : __privateGet(this, _volume));
          this.dispatchEvent(new Event("volumechange"));
          break;
        case "onError":
          this.dispatchEvent(new Event("error"));
          break;
        default:
          console.warn("Unhandled TikTok player message:", msg);
          break;
      }
    });
    __privateMethod(this, _upgradeProperty, upgradeProperty_fn).call(this, "config");
  }
  static get observedAttributes() {
    return ["src", "controls", "loop", "autoplay", "muted"];
  }
  async load() {
    if (__privateGet(this, _loadRequested))
      return;
    if (!this.shadowRoot) {
      this.attachShadow(_TikTokVideoElement.shadowRootOptions);
    }
    const isFirstLoad = !__privateGet(this, _hasLoaded);
    if (__privateGet(this, _hasLoaded)) {
      this.loadComplete = new PublicPromise();
    }
    __privateSet(this, _hasLoaded, true);
    await __privateSet(this, _loadRequested, Promise.resolve());
    __privateSet(this, _loadRequested, null);
    __privateSet(this, _currentTime, 0);
    __privateSet(this, _muted, false);
    __privateSet(this, _paused, true);
    if (!this.src) {
      this.shadowRoot.innerHTML = "";
      globalThis.removeEventListener("message", __privateGet(this, _onMessage));
      return;
    }
    let iframe = this.shadowRoot.querySelector("iframe");
    const attrs = namedNodeMapToObject(this.attributes);
    if (isFirstLoad && iframe) {
      __privateSet(this, _config, JSON.parse(iframe.getAttribute("data-config") || "{}"));
    }
    if (!(iframe == null ? void 0 : iframe.src) || iframe.src !== serializeIframeUrl(attrs, this)) {
      this.shadowRoot.innerHTML = getTemplateHTML(attrs, this);
      iframe = this.shadowRoot.querySelector("iframe");
    }
    __privateSet(this, _iframe, iframe);
    globalThis.addEventListener("message", __privateGet(this, _onMessage));
  }
  async attributeChangedCallback(attrName, oldValue, newValue) {
    if (oldValue === newValue)
      return;
    switch (attrName) {
      case "muted": {
        await this.loadComplete;
        this.muted = newValue != null;
        break;
      }
      case "autoplay":
      case "controls":
      case "loop":
      case "src": {
        this.load();
        return;
      }
    }
  }
  get config() {
    return __privateGet(this, _config);
  }
  set config(value) {
    __privateSet(this, _config, value);
  }
  async play() {
    await this.loadComplete;
    __privateMethod(this, _post, post_fn).call(this, "play");
  }
  async pause() {
    await this.loadComplete;
    __privateMethod(this, _post, post_fn).call(this, "pause");
  }
  get volume() {
    return __privateGet(this, _volume) / 100;
  }
  set volume(_val) {
    console.warn("Volume control is not supported for TikTok videos.");
  }
  get currentTime() {
    return __privateGet(this, _currentTime);
  }
  set currentTime(val) {
    __privateMethod(this, _seekTo, seekTo_fn).call(this, val);
  }
  get muted() {
    return __privateGet(this, _muted);
  }
  set muted(val) {
    __privateSet(this, _muted, val);
    val ? __privateMethod(this, _mute, mute_fn).call(this) : __privateMethod(this, _unMute, unMute_fn).call(this);
  }
  get defaultMuted() {
    return this.hasAttribute("muted");
  }
  set defaultMuted(val) {
    this.toggleAttribute("muted", !!val);
  }
  get paused() {
    return __privateGet(this, _paused);
  }
  get duration() {
    return __privateGet(this, _duration);
  }
  get src() {
    return this.getAttribute("src");
  }
  set src(val) {
    this.setAttribute("src", val ?? "");
  }
};
_loadRequested = new WeakMap();
_hasLoaded = new WeakMap();
_muted = new WeakMap();
_currentTime = new WeakMap();
_paused = new WeakMap();
_config = new WeakMap();
_volume = new WeakMap();
_duration = new WeakMap();
_iframe = new WeakMap();
_onMessage = new WeakMap();
_post = new WeakSet();
post_fn = function(type, value) {
  var _a;
  if (!((_a = __privateGet(this, _iframe)) == null ? void 0 : _a.contentWindow))
    return;
  const message = { "x-tiktok-player": true, type, ...value !== void 0 ? { value } : {} };
  __privateGet(this, _iframe).contentWindow.postMessage(message, "*");
};
_seekTo = new WeakSet();
seekTo_fn = async function(sec) {
  await this.loadComplete;
  __privateMethod(this, _post, post_fn).call(this, "seekTo", Number(sec));
};
_mute = new WeakSet();
mute_fn = async function() {
  await this.loadComplete;
  __privateMethod(this, _post, post_fn).call(this, "mute");
};
_unMute = new WeakSet();
unMute_fn = async function() {
  await this.loadComplete;
  __privateMethod(this, _post, post_fn).call(this, "unMute");
};
_upgradeProperty = new WeakSet();
upgradeProperty_fn = function(prop) {
  if (Object.prototype.hasOwnProperty.call(this, prop)) {
    const value = this[prop];
    delete this[prop];
    this[prop] = value;
  }
};
__publicField(_TikTokVideoElement, "getTemplateHTML", getTemplateHTML);
__publicField(_TikTokVideoElement, "shadowRootOptions", { mode: "open" });
let TikTokVideoElement = _TikTokVideoElement;
class PublicPromise extends Promise {
  constructor(executor = () => {
  }) {
    let res, rej;
    super((resolve, reject) => {
      executor(resolve, reject);
      res = resolve;
      rej = reject;
    });
    this.resolve = res;
    this.reject = rej;
  }
}
function namedNodeMapToObject(namedNodeMap) {
  let obj = {};
  for (let attr of namedNodeMap) {
    obj[attr.name] = attr.value;
  }
  return obj;
}
function boolToBinary(props) {
  let p = {};
  for (let key in props) {
    let val = props[key];
    if (val === true || val === "")
      p[key] = 1;
    else if (val === false)
      p[key] = 0;
    else if (val != null)
      p[key] = val;
  }
  return p;
}
function serialize(props) {
  return String(new URLSearchParams(boolToBinary(props)));
}
function serializeAttributes(attrs) {
  let html = "";
  for (const key in attrs) {
    const value = attrs[key];
    if (value === "")
      html += ` ${escapeHtml(key)}`;
    else
      html += ` ${escapeHtml(key)}="${escapeHtml(`${value}`)}"`;
  }
  return html;
}
function escapeHtml(str) {
  return str.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;").replace(/'/g, "&apos;").replace(/`/g, "&#x60;");
}
if (globalThis.customElements && !globalThis.customElements.get("tiktok-video")) {
  globalThis.customElements.define("tiktok-video", TikTokVideoElement);
}
var tiktok_video_element_default = TikTokVideoElement;
var reservedReactProps = /* @__PURE__ */ new Set([
  "style",
  "children",
  "ref",
  "key",
  "suppressContentEditableWarning",
  "suppressHydrationWarning",
  "dangerouslySetInnerHTML"
]);
var reactPropToAttrNameMap = {
  className: "class",
  htmlFor: "for"
};
function defaultToAttributeName(propName) {
  return propName.toLowerCase();
}
function defaultToAttributeValue(propValue) {
  if (typeof propValue === "boolean")
    return propValue ? "" : void 0;
  if (typeof propValue === "function")
    return void 0;
  if (typeof propValue === "object" && propValue !== null)
    return void 0;
  return propValue;
}
function createComponent({
  react: React2,
  tagName,
  elementClass,
  events,
  displayName,
  defaultProps,
  toAttributeName = defaultToAttributeName,
  toAttributeValue = defaultToAttributeValue
}) {
  const IS_REACT_19_OR_NEWER = Number.parseInt(React2.version) >= 19;
  const ReactComponent = React2.forwardRef((props, ref) => {
    var _a, _b;
    const elementRef = React2.useRef(null);
    const prevElemPropsRef = React2.useRef(/* @__PURE__ */ new Map());
    const eventProps = {};
    const attrs = {};
    const reactProps = {};
    const elementProps = {};
    for (const [k, v] of Object.entries(props)) {
      if (reservedReactProps.has(k)) {
        reactProps[k] = v;
        continue;
      }
      const attrName = toAttributeName(reactPropToAttrNameMap[k] ?? k);
      if (k in elementClass.prototype && !(k in (((_a = globalThis.HTMLElement) == null ? void 0 : _a.prototype) ?? {})) && !((_b = elementClass.observedAttributes) == null ? void 0 : _b.some((attr) => attr === attrName))) {
        elementProps[k] = v;
        continue;
      }
      if (k.startsWith("on")) {
        eventProps[k] = v;
        continue;
      }
      const attrValue = toAttributeValue(v);
      if (attrName && attrValue != null) {
        attrs[attrName] = String(attrValue);
        if (!IS_REACT_19_OR_NEWER) {
          reactProps[attrName] = attrValue;
        }
      }
      if (attrName && IS_REACT_19_OR_NEWER) {
        const attrValueFromDefault = defaultToAttributeValue(v);
        if (attrValue !== attrValueFromDefault) {
          reactProps[attrName] = attrValue;
        } else {
          reactProps[attrName] = v;
        }
      }
    }
    if (typeof window !== "undefined") {
      for (const propName in eventProps) {
        const callback = eventProps[propName];
        const useCapture = propName.endsWith("Capture");
        const eventName = ((events == null ? void 0 : events[propName]) ?? propName.slice(2).toLowerCase()).slice(
          0,
          useCapture ? -7 : void 0
        );
        React2.useLayoutEffect(() => {
          const eventTarget = elementRef == null ? void 0 : elementRef.current;
          if (!eventTarget || typeof callback !== "function")
            return;
          eventTarget.addEventListener(eventName, callback, useCapture);
          return () => {
            eventTarget.removeEventListener(eventName, callback, useCapture);
          };
        }, [elementRef == null ? void 0 : elementRef.current, callback]);
      }
      React2.useLayoutEffect(() => {
        if (elementRef.current === null)
          return;
        const newElemProps = /* @__PURE__ */ new Map();
        for (const key in elementProps) {
          setProperty(elementRef.current, key, elementProps[key]);
          prevElemPropsRef.current.delete(key);
          newElemProps.set(key, elementProps[key]);
        }
        for (const [key, _value] of prevElemPropsRef.current) {
          setProperty(elementRef.current, key, void 0);
        }
        prevElemPropsRef.current = newElemProps;
      });
    }
    if (typeof window === "undefined" && (elementClass == null ? void 0 : elementClass.getTemplateHTML) && (elementClass == null ? void 0 : elementClass.shadowRootOptions)) {
      const { mode, delegatesFocus } = elementClass.shadowRootOptions;
      const templateShadowRoot = React2.createElement("template", {
        shadowrootmode: mode,
        shadowrootdelegatesfocus: delegatesFocus,
        dangerouslySetInnerHTML: {
          __html: elementClass.getTemplateHTML(attrs, props)
        }
      });
      reactProps.children = [templateShadowRoot, reactProps.children];
    }
    return React2.createElement(tagName, {
      ...defaultProps,
      ...reactProps,
      ref: React2.useCallback(
        (node) => {
          elementRef.current = node;
          if (typeof ref === "function") {
            ref(node);
          } else if (ref !== null) {
            ref.current = node;
          }
        },
        [ref]
      )
    });
  });
  ReactComponent.displayName = displayName ?? elementClass.name;
  return ReactComponent;
}
function setProperty(node, name, value) {
  var _a;
  node[name] = value;
  if (value == null && name in (((_a = globalThis.HTMLElement) == null ? void 0 : _a.prototype) ?? {})) {
    node.removeAttribute(name);
  }
}
var react_default = createComponent({
  react: React,
  tagName: "tiktok-video",
  elementClass: tiktok_video_element_default,
  toAttributeName(propName) {
    if (propName === "muted")
      return "";
    if (propName === "defaultMuted")
      return "muted";
    return defaultToAttributeName(propName);
  }
});
/*! Bundled license information:

ce-la-react/dist/ce-la-react.js:
  (**
   * @license
   * Copyright 2018 Google LLC
   * SPDX-License-Identifier: BSD-3-Clause
   *
   * Modified version of `@lit/react` for vanilla custom elements with support for SSR.
   *)
*/
export {
  react_default as default
};
