var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField = (obj, key, value) => {
  __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var __accessCheck = (obj, member, msg) => {
  if (!member.has(obj))
    throw TypeError("Cannot " + msg);
};
var __privateGet = (obj, member, getter) => {
  __accessCheck(obj, member, "read from private field");
  return getter ? getter.call(obj) : member.get(obj);
};
var __privateAdd = (obj, member, value) => {
  if (member.has(obj))
    throw TypeError("Cannot add the same private member more than once");
  member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
};
var __privateSet = (obj, member, value, setter) => {
  __accessCheck(obj, member, "write to private field");
  setter ? setter.call(obj, value) : member.set(obj, value);
  return value;
};
var _addTrackCallback, _removeTrackCallback, _changeCallback, _tracks, tracks_get, _addRenditionCallback, _removeRenditionCallback, _changeCallback2, _selected, _selected2, _addRenditionCallback2, _removeRenditionCallback2, _changeCallback3, _selected3, _addTrackCallback2, _removeTrackCallback2, _changeCallback4, _tracks2, tracks_get2, _enabled;
class TrackEvent extends Event {
  constructor(type, init) {
    super(type);
    __publicField(this, "track");
    this.track = init.track;
  }
}
const privateProps = /* @__PURE__ */ new WeakMap();
function getPrivate(instance) {
  return privateProps.get(instance) ?? setPrivate(instance, {});
}
function setPrivate(instance, props) {
  let saved = privateProps.get(instance);
  if (!saved)
    privateProps.set(instance, saved = {});
  return Object.assign(saved, props);
}
function addVideoTrack(media, track) {
  const trackList = media.videoTracks;
  getPrivate(track).media = media;
  if (!getPrivate(track).renditionSet) {
    getPrivate(track).renditionSet = /* @__PURE__ */ new Set();
  }
  const trackSet = getPrivate(trackList).trackSet;
  trackSet.add(track);
  const index = trackSet.size - 1;
  if (!(index in VideoTrackList.prototype)) {
    Object.defineProperty(VideoTrackList.prototype, index, {
      get() {
        return [...getPrivate(this).trackSet][index];
      }
    });
  }
  queueMicrotask(() => {
    trackList.dispatchEvent(new TrackEvent("addtrack", { track }));
  });
}
function removeVideoTrack(track) {
  var _a;
  const trackList = (_a = getPrivate(track).media) == null ? void 0 : _a.videoTracks;
  if (!trackList)
    return;
  const trackSet = getPrivate(trackList).trackSet;
  trackSet.delete(track);
  queueMicrotask(() => {
    trackList.dispatchEvent(new TrackEvent("removetrack", { track }));
  });
}
function selectedChanged$2(selected) {
  const trackList = getPrivate(selected).media.videoTracks ?? [];
  let hasUnselected = false;
  for (const track of trackList) {
    if (track === selected)
      continue;
    track.selected = false;
    hasUnselected = true;
  }
  if (hasUnselected) {
    if (getPrivate(trackList).changeRequested)
      return;
    getPrivate(trackList).changeRequested = true;
    queueMicrotask(() => {
      delete getPrivate(trackList).changeRequested;
      trackList.dispatchEvent(new Event("change"));
    });
  }
}
class VideoTrackList extends EventTarget {
  constructor() {
    super();
    __privateAdd(this, _tracks);
    __privateAdd(this, _addTrackCallback, void 0);
    __privateAdd(this, _removeTrackCallback, void 0);
    __privateAdd(this, _changeCallback, void 0);
    getPrivate(this).trackSet = /* @__PURE__ */ new Set();
  }
  [Symbol.iterator]() {
    return __privateGet(this, _tracks, tracks_get).values();
  }
  get length() {
    return __privateGet(this, _tracks, tracks_get).size;
  }
  getTrackById(id) {
    return [...__privateGet(this, _tracks, tracks_get)].find((track) => track.id === id) ?? null;
  }
  get selectedIndex() {
    return [...__privateGet(this, _tracks, tracks_get)].findIndex((track) => track.selected);
  }
  get onaddtrack() {
    return __privateGet(this, _addTrackCallback);
  }
  set onaddtrack(callback) {
    if (__privateGet(this, _addTrackCallback)) {
      this.removeEventListener("addtrack", __privateGet(this, _addTrackCallback));
      __privateSet(this, _addTrackCallback, void 0);
    }
    if (typeof callback == "function") {
      __privateSet(this, _addTrackCallback, callback);
      this.addEventListener("addtrack", callback);
    }
  }
  get onremovetrack() {
    return __privateGet(this, _removeTrackCallback);
  }
  set onremovetrack(callback) {
    if (__privateGet(this, _removeTrackCallback)) {
      this.removeEventListener("removetrack", __privateGet(this, _removeTrackCallback));
      __privateSet(this, _removeTrackCallback, void 0);
    }
    if (typeof callback == "function") {
      __privateSet(this, _removeTrackCallback, callback);
      this.addEventListener("removetrack", callback);
    }
  }
  get onchange() {
    return __privateGet(this, _changeCallback);
  }
  set onchange(callback) {
    if (__privateGet(this, _changeCallback)) {
      this.removeEventListener("change", __privateGet(this, _changeCallback));
      __privateSet(this, _changeCallback, void 0);
    }
    if (typeof callback == "function") {
      __privateSet(this, _changeCallback, callback);
      this.addEventListener("change", callback);
    }
  }
}
_addTrackCallback = new WeakMap();
_removeTrackCallback = new WeakMap();
_changeCallback = new WeakMap();
_tracks = new WeakSet();
tracks_get = function() {
  return getPrivate(this).trackSet;
};
class RenditionEvent extends Event {
  constructor(type, init) {
    super(type);
    __publicField(this, "rendition");
    this.rendition = init.rendition;
  }
}
function addRendition$1(track, rendition) {
  const renditionList = getPrivate(track).media.videoRenditions;
  getPrivate(rendition).media = getPrivate(track).media;
  getPrivate(rendition).track = track;
  const renditionSet = getPrivate(track).renditionSet;
  renditionSet.add(rendition);
  const index = renditionSet.size - 1;
  if (!(index in VideoRenditionList.prototype)) {
    Object.defineProperty(VideoRenditionList.prototype, index, {
      get() {
        return getCurrentRenditions$1(this)[index];
      }
    });
  }
  queueMicrotask(() => {
    if (!track.selected)
      return;
    renditionList.dispatchEvent(new RenditionEvent("addrendition", { rendition }));
  });
}
function removeRendition$1(rendition) {
  const renditionList = getPrivate(rendition).media.videoRenditions;
  const track = getPrivate(rendition).track;
  const renditionSet = getPrivate(track).renditionSet;
  renditionSet.delete(rendition);
  queueMicrotask(() => {
    const track2 = getPrivate(rendition).track;
    if (!track2.selected)
      return;
    renditionList.dispatchEvent(new RenditionEvent("removerendition", { rendition }));
  });
}
function selectedChanged$1(rendition) {
  const renditionList = getPrivate(rendition).media.videoRenditions;
  if (!renditionList || getPrivate(renditionList).changeRequested)
    return;
  getPrivate(renditionList).changeRequested = true;
  queueMicrotask(() => {
    delete getPrivate(renditionList).changeRequested;
    const track = getPrivate(rendition).track;
    if (!track.selected)
      return;
    renditionList.dispatchEvent(new Event("change"));
  });
}
function getCurrentRenditions$1(renditionList) {
  const media = getPrivate(renditionList).media;
  return [...media.videoTracks].filter((track) => track.selected).flatMap((track) => [...getPrivate(track).renditionSet]);
}
class VideoRenditionList extends EventTarget {
  constructor() {
    super(...arguments);
    __privateAdd(this, _addRenditionCallback, void 0);
    __privateAdd(this, _removeRenditionCallback, void 0);
    __privateAdd(this, _changeCallback2, void 0);
  }
  [Symbol.iterator]() {
    return getCurrentRenditions$1(this).values();
  }
  get length() {
    return getCurrentRenditions$1(this).length;
  }
  getRenditionById(id) {
    return getCurrentRenditions$1(this).find((rendition) => `${rendition.id}` === `${id}`) ?? null;
  }
  get selectedIndex() {
    return getCurrentRenditions$1(this).findIndex((rendition) => rendition.selected);
  }
  set selectedIndex(index) {
    for (const [i, rendition] of getCurrentRenditions$1(this).entries()) {
      rendition.selected = i === index;
    }
  }
  get onaddrendition() {
    return __privateGet(this, _addRenditionCallback);
  }
  set onaddrendition(callback) {
    if (__privateGet(this, _addRenditionCallback)) {
      this.removeEventListener("addrendition", __privateGet(this, _addRenditionCallback));
      __privateSet(this, _addRenditionCallback, void 0);
    }
    if (typeof callback == "function") {
      __privateSet(this, _addRenditionCallback, callback);
      this.addEventListener("addrendition", callback);
    }
  }
  get onremoverendition() {
    return __privateGet(this, _removeRenditionCallback);
  }
  set onremoverendition(callback) {
    if (__privateGet(this, _removeRenditionCallback)) {
      this.removeEventListener("removerendition", __privateGet(this, _removeRenditionCallback));
      __privateSet(this, _removeRenditionCallback, void 0);
    }
    if (typeof callback == "function") {
      __privateSet(this, _removeRenditionCallback, callback);
      this.addEventListener("removerendition", callback);
    }
  }
  get onchange() {
    return __privateGet(this, _changeCallback2);
  }
  set onchange(callback) {
    if (__privateGet(this, _changeCallback2)) {
      this.removeEventListener("change", __privateGet(this, _changeCallback2));
      __privateSet(this, _changeCallback2, void 0);
    }
    if (typeof callback == "function") {
      __privateSet(this, _changeCallback2, callback);
      this.addEventListener("change", callback);
    }
  }
}
_addRenditionCallback = new WeakMap();
_removeRenditionCallback = new WeakMap();
_changeCallback2 = new WeakMap();
class VideoRendition {
  constructor() {
    __publicField(this, "src");
    __publicField(this, "id");
    __publicField(this, "width");
    __publicField(this, "height");
    __publicField(this, "bitrate");
    __publicField(this, "frameRate");
    __publicField(this, "codec");
    __privateAdd(this, _selected, false);
  }
  get selected() {
    return __privateGet(this, _selected);
  }
  set selected(val) {
    if (__privateGet(this, _selected) === val)
      return;
    __privateSet(this, _selected, val);
    selectedChanged$1(this);
  }
}
_selected = new WeakMap();
class VideoTrack {
  constructor() {
    __publicField(this, "id");
    __publicField(this, "kind");
    __publicField(this, "label", "");
    __publicField(this, "language", "");
    __publicField(this, "sourceBuffer");
    __privateAdd(this, _selected2, false);
  }
  addRendition(src, width, height, codec, bitrate, frameRate) {
    const rendition = new VideoRendition();
    rendition.src = src;
    rendition.width = width;
    rendition.height = height;
    rendition.frameRate = frameRate;
    rendition.bitrate = bitrate;
    rendition.codec = codec;
    addRendition$1(this, rendition);
    return rendition;
  }
  removeRendition(rendition) {
    removeRendition$1(rendition);
  }
  get selected() {
    return __privateGet(this, _selected2);
  }
  set selected(val) {
    if (__privateGet(this, _selected2) === val)
      return;
    __privateSet(this, _selected2, val);
    if (val !== true)
      return;
    selectedChanged$2(this);
  }
}
_selected2 = new WeakMap();
function addRendition(track, rendition) {
  const renditionList = getPrivate(track).media.audioRenditions;
  getPrivate(rendition).media = getPrivate(track).media;
  getPrivate(rendition).track = track;
  const renditionSet = getPrivate(track).renditionSet;
  renditionSet.add(rendition);
  const index = renditionSet.size - 1;
  if (!(index in AudioRenditionList.prototype)) {
    Object.defineProperty(AudioRenditionList.prototype, index, {
      get() {
        return getCurrentRenditions(this)[index];
      }
    });
  }
  queueMicrotask(() => {
    if (!track.enabled)
      return;
    renditionList.dispatchEvent(new RenditionEvent("addrendition", { rendition }));
  });
}
function removeRendition(rendition) {
  const renditionList = getPrivate(rendition).media.audioRenditions;
  const track = getPrivate(rendition).track;
  const renditionSet = getPrivate(track).renditionSet;
  renditionSet.delete(rendition);
  queueMicrotask(() => {
    const track2 = getPrivate(rendition).track;
    if (!track2.enabled)
      return;
    renditionList.dispatchEvent(new RenditionEvent("removerendition", { rendition }));
  });
}
function selectedChanged(rendition) {
  const renditionList = getPrivate(rendition).media.audioRenditions;
  if (!renditionList || getPrivate(renditionList).changeRequested)
    return;
  getPrivate(renditionList).changeRequested = true;
  queueMicrotask(() => {
    delete getPrivate(renditionList).changeRequested;
    const track = getPrivate(rendition).track;
    if (!track.enabled)
      return;
    renditionList.dispatchEvent(new Event("change"));
  });
}
function getCurrentRenditions(renditionList) {
  const media = getPrivate(renditionList).media;
  return [...media.audioTracks].filter((track) => track.enabled).flatMap((track) => [...getPrivate(track).renditionSet]);
}
class AudioRenditionList extends EventTarget {
  constructor() {
    super(...arguments);
    __privateAdd(this, _addRenditionCallback2, void 0);
    __privateAdd(this, _removeRenditionCallback2, void 0);
    __privateAdd(this, _changeCallback3, void 0);
  }
  [Symbol.iterator]() {
    return getCurrentRenditions(this).values();
  }
  get length() {
    return getCurrentRenditions(this).length;
  }
  getRenditionById(id) {
    return getCurrentRenditions(this).find((rendition) => `${rendition.id}` === `${id}`) ?? null;
  }
  get selectedIndex() {
    return getCurrentRenditions(this).findIndex((rendition) => rendition.selected);
  }
  set selectedIndex(index) {
    for (const [i, rendition] of getCurrentRenditions(this).entries()) {
      rendition.selected = i === index;
    }
  }
  get onaddrendition() {
    return __privateGet(this, _addRenditionCallback2);
  }
  set onaddrendition(callback) {
    if (__privateGet(this, _addRenditionCallback2)) {
      this.removeEventListener("addrendition", __privateGet(this, _addRenditionCallback2));
      __privateSet(this, _addRenditionCallback2, void 0);
    }
    if (typeof callback == "function") {
      __privateSet(this, _addRenditionCallback2, callback);
      this.addEventListener("addrendition", callback);
    }
  }
  get onremoverendition() {
    return __privateGet(this, _removeRenditionCallback2);
  }
  set onremoverendition(callback) {
    if (__privateGet(this, _removeRenditionCallback2)) {
      this.removeEventListener("removerendition", __privateGet(this, _removeRenditionCallback2));
      __privateSet(this, _removeRenditionCallback2, void 0);
    }
    if (typeof callback == "function") {
      __privateSet(this, _removeRenditionCallback2, callback);
      this.addEventListener("removerendition", callback);
    }
  }
  get onchange() {
    return __privateGet(this, _changeCallback3);
  }
  set onchange(callback) {
    if (__privateGet(this, _changeCallback3)) {
      this.removeEventListener("change", __privateGet(this, _changeCallback3));
      __privateSet(this, _changeCallback3, void 0);
    }
    if (typeof callback == "function") {
      __privateSet(this, _changeCallback3, callback);
      this.addEventListener("change", callback);
    }
  }
}
_addRenditionCallback2 = new WeakMap();
_removeRenditionCallback2 = new WeakMap();
_changeCallback3 = new WeakMap();
class AudioRendition {
  constructor() {
    __publicField(this, "src");
    __publicField(this, "id");
    __publicField(this, "bitrate");
    __publicField(this, "codec");
    __privateAdd(this, _selected3, false);
  }
  get selected() {
    return __privateGet(this, _selected3);
  }
  set selected(val) {
    if (__privateGet(this, _selected3) === val)
      return;
    __privateSet(this, _selected3, val);
    selectedChanged(this);
  }
}
_selected3 = new WeakMap();
function addAudioTrack(media, track) {
  const trackList = media.audioTracks;
  getPrivate(track).media = media;
  if (!getPrivate(track).renditionSet) {
    getPrivate(track).renditionSet = /* @__PURE__ */ new Set();
  }
  const trackSet = getPrivate(trackList).trackSet;
  trackSet.add(track);
  const index = trackSet.size - 1;
  if (!(index in AudioTrackList.prototype)) {
    Object.defineProperty(AudioTrackList.prototype, index, {
      get() {
        return [...getPrivate(this).trackSet][index];
      }
    });
  }
  queueMicrotask(() => {
    trackList.dispatchEvent(new TrackEvent("addtrack", { track }));
  });
}
function removeAudioTrack(track) {
  var _a;
  const trackList = (_a = getPrivate(track).media) == null ? void 0 : _a.audioTracks;
  if (!trackList)
    return;
  const trackSet = getPrivate(trackList).trackSet;
  trackSet.delete(track);
  queueMicrotask(() => {
    trackList.dispatchEvent(new TrackEvent("removetrack", { track }));
  });
}
function enabledChanged(track) {
  const trackList = getPrivate(track).media.audioTracks;
  if (!trackList || getPrivate(trackList).changeRequested)
    return;
  getPrivate(trackList).changeRequested = true;
  queueMicrotask(() => {
    delete getPrivate(trackList).changeRequested;
    trackList.dispatchEvent(new Event("change"));
  });
}
class AudioTrackList extends EventTarget {
  constructor() {
    super();
    __privateAdd(this, _tracks2);
    __privateAdd(this, _addTrackCallback2, void 0);
    __privateAdd(this, _removeTrackCallback2, void 0);
    __privateAdd(this, _changeCallback4, void 0);
    getPrivate(this).trackSet = /* @__PURE__ */ new Set();
  }
  [Symbol.iterator]() {
    return __privateGet(this, _tracks2, tracks_get2).values();
  }
  get length() {
    return __privateGet(this, _tracks2, tracks_get2).size;
  }
  getTrackById(id) {
    return [...__privateGet(this, _tracks2, tracks_get2)].find((track) => track.id === id) ?? null;
  }
  get onaddtrack() {
    return __privateGet(this, _addTrackCallback2);
  }
  set onaddtrack(callback) {
    if (__privateGet(this, _addTrackCallback2)) {
      this.removeEventListener("addtrack", __privateGet(this, _addTrackCallback2));
      __privateSet(this, _addTrackCallback2, void 0);
    }
    if (typeof callback == "function") {
      __privateSet(this, _addTrackCallback2, callback);
      this.addEventListener("addtrack", callback);
    }
  }
  get onremovetrack() {
    return __privateGet(this, _removeTrackCallback2);
  }
  set onremovetrack(callback) {
    if (__privateGet(this, _removeTrackCallback2)) {
      this.removeEventListener("removetrack", __privateGet(this, _removeTrackCallback2));
      __privateSet(this, _removeTrackCallback2, void 0);
    }
    if (typeof callback == "function") {
      __privateSet(this, _removeTrackCallback2, callback);
      this.addEventListener("removetrack", callback);
    }
  }
  get onchange() {
    return __privateGet(this, _changeCallback4);
  }
  set onchange(callback) {
    if (__privateGet(this, _changeCallback4)) {
      this.removeEventListener("change", __privateGet(this, _changeCallback4));
      __privateSet(this, _changeCallback4, void 0);
    }
    if (typeof callback == "function") {
      __privateSet(this, _changeCallback4, callback);
      this.addEventListener("change", callback);
    }
  }
}
_addTrackCallback2 = new WeakMap();
_removeTrackCallback2 = new WeakMap();
_changeCallback4 = new WeakMap();
_tracks2 = new WeakSet();
tracks_get2 = function() {
  return getPrivate(this).trackSet;
};
class AudioTrack {
  constructor() {
    __publicField(this, "id");
    __publicField(this, "kind");
    __publicField(this, "label", "");
    __publicField(this, "language", "");
    __publicField(this, "sourceBuffer");
    __privateAdd(this, _enabled, false);
  }
  addRendition(src, codec, bitrate) {
    const rendition = new AudioRendition();
    rendition.src = src;
    rendition.codec = codec;
    rendition.bitrate = bitrate;
    addRendition(this, rendition);
    return rendition;
  }
  removeRendition(rendition) {
    removeRendition(rendition);
  }
  get enabled() {
    return __privateGet(this, _enabled);
  }
  set enabled(val) {
    if (__privateGet(this, _enabled) === val)
      return;
    __privateSet(this, _enabled, val);
    enabledChanged(this);
  }
}
_enabled = new WeakMap();
const nativeVideoTracksFn = getBaseMediaTracksFn(globalThis.HTMLMediaElement, "video");
const nativeAudioTracksFn = getBaseMediaTracksFn(globalThis.HTMLMediaElement, "audio");
function MediaTracksMixin(MediaElementClass) {
  if (!(MediaElementClass == null ? void 0 : MediaElementClass.prototype))
    return MediaElementClass;
  const videoTracksFn = getBaseMediaTracksFn(MediaElementClass, "video");
  if (!videoTracksFn || `${videoTracksFn}`.includes("[native code]")) {
    Object.defineProperty(MediaElementClass.prototype, "videoTracks", {
      get() {
        return getVideoTracks(this);
      }
    });
  }
  const audioTracksFn = getBaseMediaTracksFn(MediaElementClass, "audio");
  if (!audioTracksFn || `${audioTracksFn}`.includes("[native code]")) {
    Object.defineProperty(MediaElementClass.prototype, "audioTracks", {
      get() {
        return getAudioTracks(this);
      }
    });
  }
  if (!("addVideoTrack" in MediaElementClass.prototype)) {
    MediaElementClass.prototype.addVideoTrack = function(kind, label = "", language = "") {
      const track = new VideoTrack();
      track.kind = kind;
      track.label = label;
      track.language = language;
      addVideoTrack(this, track);
      return track;
    };
  }
  if (!("removeVideoTrack" in MediaElementClass.prototype)) {
    MediaElementClass.prototype.removeVideoTrack = removeVideoTrack;
  }
  if (!("addAudioTrack" in MediaElementClass.prototype)) {
    MediaElementClass.prototype.addAudioTrack = function(kind, label = "", language = "") {
      const track = new AudioTrack();
      track.kind = kind;
      track.label = label;
      track.language = language;
      addAudioTrack(this, track);
      return track;
    };
  }
  if (!("removeAudioTrack" in MediaElementClass.prototype)) {
    MediaElementClass.prototype.removeAudioTrack = removeAudioTrack;
  }
  if (!("videoRenditions" in MediaElementClass.prototype)) {
    Object.defineProperty(MediaElementClass.prototype, "videoRenditions", {
      get() {
        return initVideoRenditions(this);
      }
    });
  }
  const initVideoRenditions = (media) => {
    let renditions = getPrivate(media).videoRenditions;
    if (!renditions) {
      renditions = new VideoRenditionList();
      getPrivate(renditions).media = media;
      getPrivate(media).videoRenditions = renditions;
    }
    return renditions;
  };
  if (!("audioRenditions" in MediaElementClass.prototype)) {
    Object.defineProperty(MediaElementClass.prototype, "audioRenditions", {
      get() {
        return initAudioRenditions(this);
      }
    });
  }
  const initAudioRenditions = (media) => {
    let renditions = getPrivate(media).audioRenditions;
    if (!renditions) {
      renditions = new AudioRenditionList();
      getPrivate(renditions).media = media;
      getPrivate(media).audioRenditions = renditions;
    }
    return renditions;
  };
  return MediaElementClass;
}
function getBaseMediaTracksFn(MediaElementClass, type) {
  var _a;
  if (MediaElementClass == null ? void 0 : MediaElementClass.prototype) {
    return (_a = Object.getOwnPropertyDescriptor(MediaElementClass.prototype, `${type}Tracks`)) == null ? void 0 : _a.get;
  }
}
function getVideoTracks(media) {
  let tracks = getPrivate(media).videoTracks;
  if (!tracks) {
    tracks = new VideoTrackList();
    getPrivate(media).videoTracks = tracks;
    if (nativeVideoTracksFn) {
      const nativeTracks = nativeVideoTracksFn.call(media.nativeEl ?? media);
      for (const nativeTrack of nativeTracks) {
        addVideoTrack(media, nativeTrack);
      }
      nativeTracks.addEventListener("change", () => {
        tracks.dispatchEvent(new Event("change"));
      });
      nativeTracks.addEventListener("addtrack", (event) => {
        if ([...tracks].some((t) => t instanceof VideoTrack)) {
          for (const nativeTrack of nativeTracks) {
            removeVideoTrack(nativeTrack);
          }
          return;
        }
        addVideoTrack(media, event.track);
      });
      nativeTracks.addEventListener("removetrack", (event) => {
        removeVideoTrack(event.track);
      });
    }
  }
  return tracks;
}
function getAudioTracks(media) {
  let tracks = getPrivate(media).audioTracks;
  if (!tracks) {
    tracks = new AudioTrackList();
    getPrivate(media).audioTracks = tracks;
    if (nativeAudioTracksFn) {
      const nativeTracks = nativeAudioTracksFn.call(media.nativeEl ?? media);
      for (const nativeTrack of nativeTracks) {
        addAudioTrack(media, nativeTrack);
      }
      nativeTracks.addEventListener("change", () => {
        tracks.dispatchEvent(new Event("change"));
      });
      nativeTracks.addEventListener("addtrack", (event) => {
        if ([...tracks].some((t) => t instanceof AudioTrack)) {
          for (const nativeTrack of nativeTracks) {
            removeAudioTrack(nativeTrack);
          }
          return;
        }
        addAudioTrack(media, event.track);
      });
      nativeTracks.addEventListener("removetrack", (event) => {
        removeAudioTrack(event.track);
      });
    }
  }
  return tracks;
}
export {
  MediaTracksMixin as M
};
